/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.client.CTMTexture;
import team.chisel.ctm.client.CTMClient;
import team.chisel.ctm.client.model.CTMBakedModel;
import team.chisel.ctm.client.model.CTMModelInfo;
import team.chisel.ctm.client.resource.CTMMetadataReader;
import team.chisel.ctm.client.resource.CTMMetadataSection;
import team.chisel.ctm.client.util.ResourceUtil;
import team.chisel.ctm.client.util.TextureUtil;

public class JsonCTMUnbakedModel
implements class_1100 {
    private static final CTMOverrideReader OVERRIDE_READER = new CTMOverrideReader();
    private final class_793 parent;
    private final Int2ObjectMap<JsonElement> overrides;
    private Int2ObjectMap<class_4730> identifierOverrides = new Int2ObjectArrayMap();
    private Int2ObjectMap<CTMMetadataSection> metadataOverrides = new Int2ObjectArrayMap();
    private Set<class_4730> extraTextureDependencies = new HashSet<class_4730>();
    private Set<class_4730> textureDependencies;

    public JsonCTMUnbakedModel(class_793 parent, Int2ObjectMap<JsonElement> overrides) {
        this.parent = parent;
        this.overrides = overrides;
        for (Int2ObjectMap.Entry entry : this.overrides.int2ObjectEntrySet()) {
            int tintIndex = entry.getIntKey();
            JsonElement element = (JsonElement)entry.getValue();
            CTMMetadataSection metadata = null;
            try {
                if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    class_2960 identifier = new class_2960(element.getAsString());
                    class_4730 spriteId = TextureUtil.toSpriteIdentifier(identifier);
                    this.identifierOverrides.put(tintIndex, (Object)spriteId);
                    this.extraTextureDependencies.add(spriteId);
                    metadata = ResourceUtil.getMetadataSafe(ResourceUtil.toTextureIdentifier(identifier));
                } else if (element.isJsonObject()) {
                    int provided;
                    JsonObject object = element.getAsJsonObject();
                    if (!object.has("ctm_version")) {
                        object.add("ctm_version", (JsonElement)new JsonPrimitive((Number)1));
                    }
                    JsonCTMUnbakedModel.OVERRIDE_READER.jsonModel = parent;
                    metadata = OVERRIDE_READER.fromJson(object);
                    int required = metadata.getType().requiredTextures();
                    if (required > (provided = metadata.getAdditionalTextures().length + 1)) {
                        CTMClient.LOGGER.error("Too few textures provided for override {} in model {}: TextureType {} requires {} textures, but {} were provided.", (Object)tintIndex, (Object)parent.field_4252, (Object)metadata.getType(), (Object)required, (Object)provided);
                    } else if (required < provided) {
                        CTMClient.LOGGER.warn("Too many textures provided for override {} in model {}: TextureType {} requires {} textures, but {} were provided.", (Object)tintIndex, (Object)parent.field_4252, (Object)metadata.getType(), (Object)required, (Object)provided);
                    }
                }
            }
            catch (Exception e) {
                CTMClient.LOGGER.error("Error processing CTM override.", (Throwable)e);
            }
            if (metadata == null) continue;
            for (class_2960 identifier : metadata.getAdditionalTextures()) {
                this.extraTextureDependencies.add(TextureUtil.toSpriteIdentifier(identifier));
            }
            this.metadataOverrides.put(tintIndex, (Object)metadata);
        }
    }

    public Collection<class_2960> method_4755() {
        return this.parent.method_4755();
    }

    public Collection<class_4730> method_4754(Function<class_2960, class_1100> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
        if (this.textureDependencies == null) {
            this.textureDependencies = new HashSet<class_4730>();
            this.textureDependencies.addAll(this.parent.method_4754(unbakedModelGetter, unresolvedTextureReferences));
            this.textureDependencies.addAll(this.extraTextureDependencies);
        }
        return this.textureDependencies;
    }

    public class_1087 method_4753(class_1088 loader, Function<class_4730, class_1058> spriteGetter, class_3665 rotationContainer, class_2960 modelId) {
        Map<class_2960, CTMTexture<?>> textures = TextureUtil.initializeTextures(this.textureDependencies, spriteGetter);
        Int2ObjectArrayMap spriteOverrides = new Int2ObjectArrayMap();
        for (Object entry : this.identifierOverrides.int2ObjectEntrySet()) {
            spriteOverrides.put(entry.getIntKey(), (Object)spriteGetter.apply((class_4730)entry.getValue()));
        }
        HashMultimap spriteIds = HashMultimap.create();
        for (class_785 element : this.parent.method_3433()) {
            for (class_783 face : element.field_4230.values()) {
                spriteIds.put((Object)face.field_4226, (Object)this.parent.method_24077(face.field_4224));
            }
        }
        HashMap textureOverrides = new HashMap();
        for (Int2ObjectMap.Entry entry : this.metadataOverrides.int2ObjectEntrySet()) {
            int tintIndex = entry.getIntKey();
            class_1058 sprite = (class_1058)spriteOverrides.get(tintIndex);
            if (sprite == null) {
                for (class_4730 id : spriteIds.get((Object)tintIndex)) {
                    sprite = spriteGetter.apply(id);
                    textureOverrides.put((org.apache.commons.lang3.tuple.Pair<Integer, class_2960>)org.apache.commons.lang3.tuple.Pair.of((Object)tintIndex, (Object)sprite.method_4598()), TextureUtil.makeTexture((CTMMetadataSection)entry.getValue(), sprite, spriteGetter));
                }
                continue;
            }
            textureOverrides.put((org.apache.commons.lang3.tuple.Pair<Integer, class_2960>)org.apache.commons.lang3.tuple.Pair.of((Object)tintIndex, (Object)sprite.method_4598()), TextureUtil.makeTexture((CTMMetadataSection)entry.getValue(), sprite, spriteGetter));
        }
        return new CTMBakedModel(this.parent.method_4753(loader, spriteGetter, rotationContainer, modelId), new JsonCTMModelInfo(textures, (Int2ObjectMap<class_1058>)spriteOverrides, textureOverrides));
    }

    private static class CTMOverrideReader
    extends CTMMetadataReader {
        private class_793 jsonModel;

        private CTMOverrideReader() {
        }

        @Override
        public class_2960 makeIdentifier(String string) {
            if (TextureUtil.isTextureReference(string)) {
                return this.jsonModel.method_24077(string).method_24147();
            }
            return super.makeIdentifier(string);
        }
    }

    private static class JsonCTMModelInfo
    implements CTMModelInfo {
        private final List<CTMTexture<?>> allTextures;
        private final Map<class_2960, CTMTexture<?>> textures;
        private final Int2ObjectMap<class_1058> spriteOverrides;
        private final Map<org.apache.commons.lang3.tuple.Pair<Integer, class_2960>, CTMTexture<?>> textureOverrides;

        private JsonCTMModelInfo(Map<class_2960, CTMTexture<?>> textures, Int2ObjectMap<class_1058> spriteOverrides, Map<org.apache.commons.lang3.tuple.Pair<Integer, class_2960>, CTMTexture<?>> textureOverrides) {
            this.textures = textures;
            this.spriteOverrides = spriteOverrides;
            this.textureOverrides = textureOverrides;
            this.allTextures = ImmutableList.builder().addAll(this.textures.values()).addAll(this.textureOverrides.values()).build();
        }

        @Override
        public Collection<CTMTexture<?>> getTextures() {
            return this.allTextures;
        }

        @Override
        public CTMTexture<?> getTexture(class_2960 identifier) {
            return this.textures.get(identifier);
        }

        @Override
        @Nullable
        public class_1058 getOverrideSprite(int tintIndex) {
            return (class_1058)this.spriteOverrides.get(tintIndex);
        }

        @Override
        @Nullable
        public CTMTexture<?> getOverrideTexture(int tintIndex, class_2960 identifier) {
            return this.textureOverrides.get(org.apache.commons.lang3.tuple.Pair.of((Object)tintIndex, (Object)identifier));
        }
    }
}

